@ECHO OFF
:: Copyright 2017 The Android Open Source Project
::
:: Licensed under the Apache License, Version 2.0 (the "License");
:: you may not use this file except in compliance with the License.
:: You may obtain a copy of the License at
::
::      http://www.apache.org/licenses/LICENSE-2.0
::
:: Unless required by applicable law or agreed to in writing, software
:: distributed under the License is distributed on an "AS IS" BASIS,
:: WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
:: See the License for the specific language governing permissions and
:: limitations under the License.

:: The fastboot executable must be in your path to run this script, and the
:: image files to flash must be in the current directory.

PATH=%PATH%;"%SYSTEMROOT%\System32"

:: Environment variable options
::
:: These options when calling this batch file, for example:
::   cmd /C "SET "REBOOT=false" && flash-all.bat"
::
:: By default, flash-all will flash the MT8516 image. To specify a particular
:: product variant, BOARD should be set to the variant name.
IF DEFINED BOARD SET BOARD=_%BOARD%
:: By default, flash-all will reboot the device out of fastboot mode when it is
:: done flashing.
IF NOT DEFINED REBOOT SET REBOOT=true
:: By default, don't flash oem partition containing GMSCore. Override to
:: oem_dev.img/vbmeta_dev.img if available.
IF NOT DEFINED USE_GMSCORE SET USE_GMSCORE=false
:: By default, flash-all will check if the device is AVB locked and error out if
:: so. Override to flash anyway.
IF NOT DEFINED FLASH_IF_LOCKED SET FLASH_IF_LOCKED=false
:: By default, flash the factory partition if an image is present.
IF NOT DEFINED FLASH_FACTORY_DATA SET FLASH_FACTORY_DATA=true


:: Try to protect user from triggering rollback protection when flashing. Check
:: the AVB lock state and only allow flashing if the device is unlocked or if the
:: user explicitly overrides using the FLASH_IF_LOCKED environment variable.
FOR /F "tokens=3 delims= " %%I IN ('fastboot getvar at-vboot-state 2^>^&1 ^| findstr avb-locked') DO SET AVB_LOCKED=%%I
IF NOT DEFINED AVB_LOCKED (
  IF "%FLASH_IF_LOCKED%"=="true" (
    ECHO Couldn't determine AVB lock state but FLASH_IF_LOCKED is set. Continuing with flashing.
  ) ELSE (
    ECHO Couldn't determine AVB lock state. Flashing may trigger rollback protection.
    ECHO Set 'FLASH_IF_LOCKED=true' to override.
    EXIT /B
  )
) ELSE (
  IF "%AVB_LOCKED%"=="0" (
    ECHO AVB is unlocked. Flashing.
  ) ELSE (
    IF "%FLASH_IF_LOCKED%"=="true" (
      ECHO AVB is locked but FLASH_IF_LOCKED is set. Overriding and continuing with flashing.
    ) ELSE (
      ECHO AVB is locked. Flashing may trigger rollback protection.
      ECHO Unlock first or set 'FLASH_IF_LOCKED=true' to override.
      EXIT /B
    )
  )
)

:: Check whether this board still has the older preloader/lk and partition table,
:: before the rename to lk_a/lk_b and before proper partition table support in
:: the bootloader. If so, we need to update it to the newer one with a modified
:: flash procedure. We query the 'lk' partition size to determine if the table is
:: old. Size will be non-empty if the partition exists:
::   [old] partition-size:lk: 60000
::   [new] partition-size:lk:
SET LK_PART_SIZE=
SET LK_PART_SIZE_NUMERIC=

FOR /F "tokens=2 delims= " %%A IN ('fastboot getvar partition-size:lk 2^>^&1 ^| findstr partition-size') DO SET LK_PART_SIZE=%%A
FOR /F "delims=x0123456789abcdefABCDEF" %%B IN ("%LK_PART_SIZE%") DO SET LK_PART_SIZE_NOT_NUMERIC=%%B
:: Old 'lk' partition exists if we got a non-empty result from getvar that is
:: numeric (aka not not-numeric)
IF DEFINED LK_PART_SIZE ^
IF NOT DEFINED LK_PART_SIZE_NOT_NUMERIC (
  ECHO Detected old partition table, updating...
  fastboot ^
    flash boot0     boot0.img ^
    flash tee1      tee.img ^
    flash tee2      tee.img ^
    flash lk        lk.img^
    flash lk2       lk.img^
    flash partition partition-table.img ^
    reboot bootloader ^
    %* || GOTO :EOF
    ping -n 5 127.0.0.1 >nul
)

:: Minimal flash commands needed to flash potentially changed
:: partition table and reboot back into the bootloader
fastboot ^
    flash boot0     boot0.img ^
    flash partition partition-table.img ^
    flash tee_a     tee.img ^
    flash tee_b     tee.img ^
    flash lk_a      lk.img^
    flash lk_b      lk.img^
    erase misc ^
    set_active a ^
    %* || GOTO :EOF

:: Flash everything else.
:: Erase the misc partition to clear out any stale state, such as whether to
:: reboot into recovery
fastboot ^
    flash boot_a     boot.img ^
    flash boot_b     boot.img ^
    flash system_a   system.img ^
    flash system_b   system.img ^
    flash vendor_a   vendor.img ^
    flash vendor_b   vendor.img ^
    flash logo       logo.img ^
    %* || GOTO :EOF

IF NOT EXIST oem_dev.img (
    ECHO oem_dev.img not found, falling back to using oem.img and vbmeta.img.
    SET USE_GMSCORE=false
)

IF NOT EXIST vbmeta_dev.img (
    ECHO vbmeta_dev.img not found, falling back to using oem.img and vbmeta.img.
    SET USE_GMSCORE=false
)

IF "%USE_GMSCORE%"=="true" (
    fastboot ^
        flash oem_a      oem_dev.img ^
        flash oem_b      oem_dev.img ^
        flash vbmeta_a   vbmeta_dev.img ^
        flash vbmeta_b   vbmeta_dev.img ^
        %* || GOTO :EOF
) ELSE (
    fastboot ^
        flash oem_a      oem%BOARD%.img ^
        flash oem_b      oem%BOARD%.img ^
        flash vbmeta_a   vbmeta%BOARD%.img ^
        flash vbmeta_b   vbmeta%BOARD%.img ^
        %* || GOTO :EOF
)

IF EXIST oem_bootloader.img (
    fastboot ^
        flash oem_bootloader_a oem_bootloader%BOARD%.img ^
        flash oem_bootloader_b oem_bootloader%BOARD%.img ^
        %* || GOTO :EOF
)

IF "%FLASH_FACTORY_DATA%"=="true" (
    IF EXIST factory.img (
        fastboot ^
            flash factory       factory.img ^
            %* || GOTO :EOF
    ) ELSE (
        ECHO No factory image found, skipping.
    )
)

:: Must reboot before trying to format userdata (b/66924340)
fastboot reboot bootloader %* || GOTO :EOF
ping -n 5 127.0.0.1 >nul
fastboot format userdata %* || GOTO:EOF

IF "%REBOOT%"=="true" (
  fastboot %* reboot
) ELSE (
  ECHO Skipping reboot and staying in fastboot mode.
)

ECHO:
ECHO Successfully flashed your mt8516.
